/* 
Function supplied with Fwatch v1.14
Returns dialog space format

Usage:
	_string = call preProcessFile "..\fwatch\data\getAspectRatio.sqf"

Where _string is aspect ratio (e.g. 4:3 is "4_3")
*/



private ["_data", "_config", "_ok", "_i", "_done"];



// Predefined values for each aspect ratio setting

	_data = 
	[
		["4_3", 0, 0, 1, 1],
		["16_9", 0.125, 0, 0.875, 1],
		["15_9", 0.125, 0.033333, 0.875, 0.966667],
		["16_10", 0.083333, 0, 0.916667, 1],
		["5_4", 0, 0.033333, 1, 0.966667],
		
		["4_3", 0.333333, 0, 0.666667, 1],
		["16_9", 0.375, 0, 0.625, 1],
		["15_9", 0.375, 0, 0.625, 1],
		["16_10", 0.361111, 0, 0.638889, 1],
		["5_4", 0.333333, 0.033333, 0.666667, 0.966667]
	];
	


// Read user configuration

	_config = ["",0,0,0,0];
	_ok = call loadFile Format [":class token ""f:..\Users\%1\userInfo.cfg"" n", name player];
	if (_ok select 0) then 
	{
		_i = 0;
		_done = 0;
		while "_i < count (_ok select 6)  &&  _done<6" do
		{
			if ((_ok select 6) select _i == "uiTopLeftX") then {_config set [1,(_ok select 7) select _i]; _done=_done+1};
			if ((_ok select 6) select _i == "uiTopLeftY") then {_config set [2,(_ok select 7) select _i]; _done=_done+1};
			if ((_ok select 6) select _i == "uiBottomRightX") then {_config set [3,(_ok select 7) select _i]; _done=_done+1};
			if ((_ok select 6) select _i == "uiBottomRightY") then {_config set [4,(_ok select 7) select _i]; _done=_done+1};
			_i = _i + 1;
		};
	};
	


// Compare user info to predefined data

	_i = 0;
	while "_i < count _data" do
	{			
		// UI settings match
		if ((_config select 3) == ((_data select _i) select 3) &&
			(_config select 4) == ((_data select _i) select 4) &&
			(_config select 5) == ((_data select _i) select 5) &&
			(_config select 6) == ((_data select _i) select 6)) then 
		{
			_config set [0, (_data select _i) select 0];
		};
		
		_i = _i + 1;
	};
	
	_config select 0
